<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Pocket extends Model 
{

    protected $table = 'pockets';
    public $timestamps = true;
    protected $fillable = array('user_id', 'name', 'currency', 'isShared', 'isHistory');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Transaction', 'pockets_id');
    }

    public function pockets_shared()
    {
        return $this->hasMany('App\Models\PocketShared', 'pockets_id');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification', 'pocket_id');
    }

}